#============================================================================== 
# ** Modules.View Range (5.0)               By Near Fantastica & SephirothSpawn
#------------------------------------------------------------------------------
# * Description :
#
#   The View Range Module is used to test objects position in comparision with
#   another object. It can test if an object is within a defined circular
#   range of another object or a rectangular defined region. It can also tell
#   you this distances between objects.
#------------------------------------------------------------------------------
# * Syntax :
#
#   Test if object is within defined range from another object :
#    - VR.in_range?(object1, object2, range)
#    - VR.in_range?(object1x, object1y, object2x, object2y, range)
#
#   Test if object is within defined rectanlge :
#    - VR.in_rect_range?(object, <args>)
#    - VR.in_rect_range?(x, y, <args>)
#
#    args can either be : x, y, width, height or Rect.new(x, y, width, height)
#
#   Test range between objects :
#    - range = VR.range(object1, object2, <integer>)
#    - range = VR.range(object1x, object1y, object2x, object2y, <integer>)
#
#    integer : if true, returns integer ; if false, returns float
#==============================================================================

MACL::Loaded << 'Modules.View Range'

#==============================================================================
# ** View Range
#==============================================================================

module VR
  #----------------------------------------------------------------------------
  # * Within Range Test
  #----------------------------------------------------------------------------
  def VR.in_range?(*args)
    # If 3 Arguments (Element, Object, Range)
    if args.size == 3
      x = (args[0].x - args[1].x) ** 2
      y = (args[0].y - args[1].y) ** 2
      r = args[2]
    # If 5 Arguments (Elementx, Elementy, Objectx, Objecty, Range)
    elsif args.size == 5
      x = (args[0] - args[2]) ** 2
      y = (args[1] - args[3]) ** 2
      r = args[4]
    else
      p 'Wrong Defined Number of Arguments'
      return 
    end
    return (x + y) <= (r * r)
  end
  #----------------------------------------------------------------------------
  # * Within Rect Range Test
  #----------------------------------------------------------------------------
  def VR.in_rect_range?(*args)
    # If 2 Arguments (Object, Rect)
    if args.size == 2
      x_, y_ = args[0].x, args[0].y
      x, y, w, h = args[1].x, args[1].y, args[1].width, args[1].height
    # If 3 Arguments (Objectx, Objecty, Rect)
    elsif args.size == 3
      x_, y_ = args[0], args[1]
      x, y, w, h = args[2].x, args[2].y, args[2].width, args[2].height
    # If 5 Arguments (Object, Rectx, Recty, Rectwidth, Rectheight)
    elsif args.size == 5
      x_, y_ = args[0].x, args[0].y
      x, y, w, h = args[1], args[2], args[3], args[4]
    # If 6 Arguments (Objectx, Objecty, Rectx, Recty, Rectwidth, Rectheight)
    elsif args.size == 6
      x_, y_, x, y, w, h = *args
    else
      p 'Wrong Defined Number of Arguments'
      return
    end
    # Return Object Within Rect
    return x_.between?(x, x + w) && y_.between?(y, y + h)
  end
  #----------------------------------------------------------------------------
  # * Range
  #----------------------------------------------------------------------------
  def VR.range(*args)
    # If 2 Arguments (Element, Object)
    if args.size == 2
      x = (args[0].x - args[1].x) * (args[0].x - args[1].x)
      y = (args[0].y - args[1].y) * (args[0].y - args[1].y)
      integer = true
    # If 3 Arguments (Element, Object, Integer
    elsif args.size == 3
      x = (args[0].x - args[1].x) * (args[0].x - args[1].x)
      y = (args[0].y - args[1].y) * (args[0].y - args[1].y)
      integer = args[2]
    # If 4 Arguments (Elementx, Elementy, Objectx, Objecty)
    elsif args.size == 4
      x = (args[0] - args[2]) * (args[0] - args[2])
      y = (args[1] - args[3]) * (args[1] - args[3])
      integer = true
    # If 5 Arguments (Elementx, Elementy, Objectx, Objecty, integer)
    elsif args.size == 5
      x = (args[0] - args[2]) * (args[0] - args[2])
      y = (args[1] - args[3]) * (args[1] - args[3])
      integer = args[4]
    else
      p 'Wrong Defined Number of Arguments'
      return
    end
    r = Math.sqrt(x + y)
    return integer ? r.to_i : r
  end
end